<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use App\DBRealTestSupport\TableCreation as TC;

class AdminRoleMother
{

    public static function build1($id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_AdminRole'                => $id,
            'AdminRole_Name'            => Str::title($faker->text(rand(5, 100))),
            'AdminRole_Abrv'            => Str::upper(Util::generateString(4)),
            'AdminRole_Color'            => Str::upper($faker->text(rand(5, 10))),
            'AdminRole_Admin'            => 2,
            'AdminRole_CalendarAccess'  => $faker->randomElement([0, 1]),
            'AdminRole_Status'            => 2,
        ];
    }

    public static function push1($id = 1)
    {
        return self::push(self::build1($id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_admin_role_insert` (?,?,?,?,?,?)", [
            $object['AdminRole_Name'],
            $object['AdminRole_Abrv'],
            $object['AdminRole_Color'],
            $object['AdminRole_Admin'],
            $object['AdminRole_CalendarAccess'],
            $object['AdminRole_Status'],
        ])[0];
        $object['Id_AdminRole'] = $response->Response_Id;
        return $object;
    }

    public static function tablesToClear()
    {
        return [TC::ADMIN_ROLE];
    }
}
