<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class AdminRoleAuthMother {
    
    public static function build1($idAdminRole, $idDirectory, $id = 1) {
        $faker = Factory::create();
        return [
            'Id_AdminRoleAuth'          => $id,
            'AdminRoleAuth_Insert'      => $faker->randomElement([0, 1]),
            'AdminRoleAuth_Update'      => $faker->randomElement([0, 1]),
            'AdminRoleAuth_Delete'      => $faker->randomElement([0, 1]),
            'Id_AdminRole'              => $idAdminRole,
            'Id_Directory'              => $idDirectory,
        ];
    }
    
    public static function build2($idAdminRole, $idDirectory, $id = 0) {
        $faker = Factory::create();
        return [
            'Id_AdminRoleAuth'          => $id,
            'AdminRoleAuth_Insert'      => $faker->randomElement([0, 1]),
            'AdminRoleAuth_Update'      => $faker->randomElement([0, 1]),
            'AdminRoleAuth_Delete'      => $faker->randomElement([0, 1]),
            'AdminRoleAuth_Status'      => $faker->randomElement([1]),
            'Id_AdminRole'              => $idAdminRole,
            'Id_Directory'              => $idDirectory,
        ];
    }

    public static function push1($idAdminRole, $idDirectory, $id = 1) {
        return self::push(self::build1($idAdminRole, $idDirectory, $id));
    }

    private static function push($object) {
        $response = DB::select("CALL `sp_admin_role_auth_insert` (?,?,?,?,?)", [
            $object['AdminRoleAuth_Insert'],
            $object['AdminRoleAuth_Update'],
            $object['AdminRoleAuth_Delete'],
            $object['Id_AdminRole'],
            $object['Id_Directory'],
        ])[0];
        $object['Id_AdminRoleAuth'] = $response->Response_Id;
        return $object;
    }

}