<?php

namespace App\Console;

use App\Modules\Shared\Domain\ValueObject\DateTimeValueObject;
use App\Modules\Shared\Domain\ValueObject\DateValueObject;
use App\Modules\Shared\Domain\ValueObject\TimeValueObject;
use App\Tasks\Media\DeleteGroupProviderMedia;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        $date = new DateTimeValueObject(date('Y-m-d 19:00:00'));
        $reduced = DateTimeValueObject::upgradeDatetimeFromPeruToUTC($date);

        $schedule->call(app()->make(DeleteGroupProviderMedia::class))
            ->daily()
            ->at($reduced->value(TimeValueObject::format()));

        // $schedule->call(app()->make(DeleteGroupProviderMedia::class));
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}
